/*
 * Created on 02.01.2005
 * Copyright (C) 2004 Sebastian Baltes (sebastian.baltes@gmx.de)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 */
package de.sbaltes.jspwiki.filters;

import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import com.ecyrd.jspwiki.WikiContext;
import com.ecyrd.jspwiki.filters.BasicPageFilter;
import com.ecyrd.jspwiki.filters.FilterException;

/**
 * @author Sebastian Baltes
 */
public class InitialFilter extends BasicPageFilter {
    
  Pattern pattern = Pattern.compile("(?:\\\\(\\w)\\\\|\\(\\w)\\)");
  
  public void initialize(Properties properties) throws FilterException {
  }
  
  public String postTranslate(WikiContext context, String html) throws FilterException {
    StringBuffer b = new StringBuffer(html);
    Matcher m = pattern.matcher(html);
    int offset=0;
    while (m.find()) {
      String letter; 
      if (m.group(1)!=null) {
        letter = m.group(1);
      } else {
        letter = m.group(2)+"1";      	
      }
      String initialLink = "initial/"+letter.toLowerCase()+".gif";
      String initialHtml = "<img src=\""+initialLink+"\" align=\"left\" style=\"margin-right:0.5em\"/><p style=\"text-indent:0em;\">"; 
      b.replace(m.start()-offset, m.end()-offset, initialHtml);
      offset-=initialHtml.length()-(m.end()-m.start());
    }
    return b.toString();
  }
  
  public static void main(String agrs[]) throws Exception {
    String html = "<p>Seit nunmehr 8 Jahren spielen wir regelmig <a class=\"interwiki\" href=\"http://www.google.com/search?q=earthdawn\">Earthdawn</a><img class=\"outlink\" src=\"images/out.png\" alt=\"\" />. <i>Der Name dieser Website kommt brigens von meinem Alter Ego <a class=\"wikipage\" href=\"Wiki.jsp?page=Sorokan\">Sorokan</a>, einem waschechten Magier.</i>";
    System.out.println(new InitialFilter().postTranslate(null,html));    
  }
}

