/*
 * Created on 24.07.2004
 * Copyright (C) 2004 Sebastian Baltes (sebastian.baltes@gmx.de)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 */
package com.ecyrd.jspwiki.plugin;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.util.Map;
import java.util.StringTokenizer;

import Acme.JPM.Encoders.GifEncoder;

import com.ecyrd.jspwiki.WikiContext;

/**
 * Plugin that displays latex math syntax as gif images.
 * Parameters may also be read from JspWiki-Properties. In this case the parameter names 
 * with prefix "math." are used as property names.
 *
 * @author Sebastian Baltes
 */
public class Text2gif extends ACachedPlugin {

  public static final String PARAM_TEXT = "text";

  public static final String PARAM_ALIGN = "align";

  public static final String PARAM_HEIGHT = "height";

  public static final String PARAM_WIDTH = "width";

  public static final String PARAM_FONT_SIZE = "fontsize";

  public static final String PARAM_COLOR = "color";

  public static final String PARAM_BGCOLOR = "bgcolor";

  protected void fillCache(WikiContext context, Map params, CacheHolder cacheHolder) throws Exception {
      // parse Parameters 
    PluginParameterParser parser = new PluginParameterParser(params, "Text2gif plugin");      
    parser.setDefaultParams(context.getEngine().getWikiProperties(),"text2gif.");
    String text;
    try {
      text = parser.getString(PARAM_TEXT);
    } catch (ParameterNotFoundException e) {
      text = parser.getString(PluginManager.PARAM_BODY, null);
      if (text==null) {
        throw e;
      }
    }
    Integer width = parser.getInteger(PARAM_WIDTH);
    Integer height = parser.getInteger(PARAM_HEIGHT);
    Integer fontSize = parser.getInteger(PARAM_FONT_SIZE, null);
    Color color = parser.getColor(PARAM_COLOR, Color.BLACK);
    Color bgcolor = parser.getColor(PARAM_BGCOLOR, Color.WHITE);
    String align = parser.getString(PARAM_ALIGN, null);

    // create gif
    BufferedImage bufferedImage = new BufferedImage(width.intValue(), height.intValue(), BufferedImage.TYPE_INT_RGB);
    Graphics graphics = bufferedImage.getGraphics();
    graphics.setColor(bgcolor);
    graphics.fillRect(0, 0, width.intValue(), height.intValue());
    graphics.setColor(color);
    if (fontSize!=null) {
      graphics.setFont(new Font(graphics.getFont().getFontName(),Font.PLAIN,fontSize.intValue()));
    }    
    StringTokenizer t = new StringTokenizer(text,"\n");
    int h = 3;
    while (t.hasMoreTokens()) {
      h += graphics.getFontMetrics().getHeight();
      graphics.drawString(t.nextToken(),5,h);      
    }
    
    ByteArrayOutputStream bout = new ByteArrayOutputStream();
    new GifEncoder(bufferedImage, bout).encode();
    DownloadHolder download = new DownloadHolder("text.gif", "image/gif", bout.toByteArray());
    String downloadUrl = cacheHolder.getCachedDownloadUrl(context, download);

    // write html
    StringBuffer result = new StringBuffer();
    result.append("<table border=\"0\"");
    if (align != null) {
      result.append(" align=\"" + align + "\"");
    }
    result.append(">\n");
    result.append("<tr><td>");
    result.append("<img src=\"" + downloadUrl + "\" class=\"textgif\"");
    result.append(" alt=\"" + text + "\"");
    result.append(" />");
    result.append("</td></tr>\n");
    result.append("</table>\n");
    
    cacheHolder.setResult(result.toString());
  }

}