package com.ecyrd.jspwiki.plugin;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;

import org.apache.log4j.Category;

import com.ecyrd.jspwiki.PageManager;
import com.ecyrd.jspwiki.WikiContext;
import com.ecyrd.jspwiki.WikiEngine;
import com.ecyrd.jspwiki.WikiPage;
import com.ecyrd.jspwiki.WikiProvider;
import com.ecyrd.jspwiki.providers.ProviderException;
import com.ecyrd.jspwiki.providers.WikiPageProvider;

/**
 * created by SimonLei. Modified by Sebastian Baltes
 */
public class SbPageViewCountPlugin implements WikiPlugin {
	private static Category log = Category.getInstance(SbPageViewCountPlugin.class);

	private static HashMap counters = null;

	private static Thread counterSaveThread = null;

	public static final String COUNTER_PAGE = "PageCount";

	private static String ROOT = null;

	private static WikiContext context;

	private synchronized void loadProperties()
			throws ProviderException, IOException {
		if (counters == null) {
			counters = new HashMap();
   		    WikiEngine engine = context.getEngine();
			String pageText = engine.getPureText(COUNTER_PAGE,WikiProvider.LATEST_VERSION);
			if (pageText!=null) {
				Properties stringCounters = new Properties();
				stringCounters.load(new ByteArrayInputStream(pageText.getBytes()));
				Enumeration enu = stringCounters.propertyNames();
				while (enu.hasMoreElements()) {
					String str = (String) enu.nextElement();
					counters.put(str, new Counter(stringCounters.getProperty(str)));
				}				
			}
			if (counterSaveThread == null) {
				counterSaveThread = new CounterSaveThread();
				counterSaveThread.start();
			}
		}
	}

	public String execute(WikiContext pContext, Map params)
			throws PluginException {
		context = pContext;
		WikiPage page = context.getPage();

		try {
			loadProperties();
		} catch (Exception e) {
			log.error("error reading PageCounter.txt",e);
			throw new PluginException(e.toString());
		}

		if (page == null)
			return "0";
		String pageName = page.getName();
		synchronized (counters) {
			Counter counter = (Counter) counters.get(pageName);
			if (counter == null) {
				counter = new Counter(0);
				counters.put(pageName, counter);
			}
			counter.increase();
			return counter.toString();
		}
	}

	class Counter {
		private int count;

		public Counter(int _count) {
			count = _count;
		}

		public Counter(String _count) {
			try {
				count = Integer.parseInt(_count);
			} catch (Exception e) {
				count = 0;
			}
		}

		public void increase() {
			count++;
		}

		public String toString() {
			return "" + count;
		}
	}

	class CounterSaveThread extends Thread {
		public void run() {
			try {
				while (true) {
					synchronized (counters) {
						try {
							Properties stringCounters = new Properties();
							Iterator iter = counters.keySet().iterator();
							while (iter.hasNext()) {
								Object key = iter.next();
								stringCounters.put(key, counters.get(key)
										.toString());
							}
							ByteArrayOutputStream bout = new ByteArrayOutputStream();
							stringCounters
									.store(bout,
											"The view counts for pages. Don't modify it.");
							String pageText = new String(bout.toByteArray());
                  		    WikiEngine engine = context.getEngine();
                  		    WikiPageProvider pageProvider = engine.getPageManager().getProvider();
                  	        WikiPage pageInfo = pageProvider.getPageInfo(COUNTER_PAGE, WikiProvider.LATEST_VERSION );
                  	        if (pageInfo==null) {
                  	        	pageInfo = new WikiPage(COUNTER_PAGE); 
                  	        }
                  	        pageProvider.putPageText(pageInfo, pageText);
						} catch (Exception e1) {
							log.error("error storing PageCounter.txt",e1);
						}
					}
					Thread.sleep(60*1000);
				}
			} catch (InterruptedException e) {				
				log.info("The counter store thread interrupted. No more counter saved.");
			}
		}
	}

}