/*
 * Created on 23.10.2004
 * Copyright (C) 2004 Sebastian Baltes (sebastian.baltes@gmx.de)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 */
package com.ecyrd.jspwiki.plugin;

import java.util.NoSuchElementException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * @author Sebastian Baltes
 */
public class PluginScanner {

  public static void appendTextToPlugin(StringBuffer pageText, String pluginName, String pluginId, String textToAppend) throws NoSuchElementException {
    Pattern pluginPattern = Pattern.compile("\\[\\{"+pluginName+"\\b.*\\b"+pluginId);      
    Matcher matcher = pluginPattern.matcher(pageText);
    if (matcher.find()) {
      int start = matcher.start();
      int end = pageText.indexOf("}]", start);      
      if (end>=0) {            
        int newLines = 0;
        for (int i = start; i < end; i++) {
          if (pageText.charAt(i)=='\n') {
            newLines++;
          }
        }
        while (newLines<2) {
          pageText.insert(end, "\n");
          newLines++;
          end++;
        }
        pageText.insert(end, textToAppend);
      } else {
        throw new NoSuchElementException();
      }
    } else {
      throw new NoSuchElementException();
    }    
  }
}
