/*
 * Created on 24.07.2004
 * Copyright (C) 2004 Sebastian Baltes (sebastian.baltes@gmx.de)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 */
package com.ecyrd.jspwiki.plugin;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;

import Acme.JPM.Encoders.GifEncoder;
import atp.cHotEqn;

/**
 * @author Sebastian Baltes
 */
public class MathHotEnqGifWriter {

  private String equation;
  private int maxWidth = 700;
  private int maxHeight = 200;
  private Color backgroundColor = Color.white;
  private Color foregroundColor = Color.black;
  private Integer fontSize;
  private int[] defaultFontSizes = new int[] {16,14,10,8};
  
  public MathHotEnqGifWriter() {
  }

  /**
   * @param equation
   * @param width
   * @param height
   */
  public MathHotEnqGifWriter(String equation) {
    this.equation = equation;
  }

  /**
   * @param mathString
   * @param outputStream
   * @param width
   * @param height
   * @throws IOException
   */
  public void write(OutputStream outputStream) throws IOException {    
    BufferedImage bufferedImage = new BufferedImage(maxWidth, maxHeight, BufferedImage.TYPE_INT_RGB);
    Graphics graphics = bufferedImage.getGraphics();
    PrintStream oldOut = System.out;
    System.setOut(new PrintStream(new ByteArrayOutputStream()));
    cHotEqn hoteqn = new cHotEqn() {
      public Image createImage(int w, int h) {
        return new BufferedImage(w, h, BufferedImage.TYPE_INT_RGB);
      }
    };
    hoteqn.setBounds(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
    hoteqn.setEquation(equation);
    hoteqn.setEditable(false);
    int[] fontSizes;
    if (fontSize!=null) {
      fontSizes = getFontSizes(fontSize.intValue());    
    } else {
      fontSizes = defaultFontSizes;
    }
    hoteqn.setFontsizes(fontSizes[0],fontSizes[1],fontSizes[2],fontSizes[3]);
    hoteqn.setBackground(backgroundColor);
    hoteqn.setForeground(foregroundColor);
    hoteqn.paint(graphics);
    System.setOut(oldOut);
    Image image = trimImageSize(bufferedImage);
    new GifEncoder(image, outputStream).encode();
  }
  
  private int[] getFontSizes(int size) {
    int[] sizes = new int[4];
    sizes[0]=size;
    for (int i = 1; i < sizes.length; i++) {
      sizes[i]=java.lang.Math.round(sizes[i-1]*0.75F);
    }
    return sizes;
  }

  /**
   * @param bufferedImage
   * @return
   */
  private Image trimImageSize(BufferedImage bufferedImage) {
    int maxw = 0;
    int maxh = maxHeight-1;    
    int color = backgroundColor.getRGB();
    for (int y = maxh-1; y>=0; y-- ) {
      for (int x = maxWidth-1; x>=maxw; x-- ) {
        if (bufferedImage.getRGB(x,y)!=color) {
          maxw=x;
          if (maxh==maxHeight-1) {
            maxh=y;
          }
          break;
        }
      }
    }
    return bufferedImage.getSubimage(0,0,java.lang.Math.min(maxw+5,maxWidth),java.lang.Math.min(maxh+3,maxHeight));
  }

  /**
   * @return Returns the backgroundColor.
   */
  public Color getBackgroundColor() {
    return backgroundColor;
  }
  /**
   * @param backgroundColor The backgroundColor to set.
   */
  public void setBackgroundColor(Color backgroundColor) {
    this.backgroundColor = backgroundColor;
  }
  /**
   * @return Returns the equation.
   */
  public String getEquation() {
    return equation;
  }
  /**
   * @param equation The equation to set.
   */
  public void setEquation(String equation) {
    this.equation = equation;
  }
  /**
   * @return Returns the fontSizes.
   */
  public Integer getFontSize() {
    return fontSize;
  }
  /**
   * @param fontSizes The fontSizes to set.
   */
  public void setFontSize(Integer fontSize) {
    this.fontSize = fontSize;
  }
  /**
   * @return Returns the foregroundColor.
   */
  public Color getForegroundColor() {
    return foregroundColor;
  }
  /**
   * @param foregroundColor The foregroundColor to set.
   */
  public void setForegroundColor(Color foregroundColor) {
    this.foregroundColor = foregroundColor;
  }
  /**
   * @return Returns the maxHeight.
   */
  public int getMaxHeight() {
    return maxHeight;
  }
  /**
   * @param maxHeight The maxHeight to set.
   */
  public void setMaxHeight(int maxHeight) {
    this.maxHeight = maxHeight;
  }
  /**
   * @return Returns the maxWidth.
   */
  public int getMaxWidth() {
    return maxWidth;
  }
  /**
   * @param maxWidth The maxWidth to set.
   */
  public void setMaxWidth(int maxWidth) {
    this.maxWidth = maxWidth;
  }
}