/*
 * Created on 24.07.2004
 * Copyright (C) 2004 Sebastian Baltes (sebastian.baltes@gmx.de)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 */
package com.ecyrd.jspwiki.plugin;

import java.awt.Color;
import java.io.ByteArrayOutputStream;
import java.util.Map;

import com.ecyrd.jspwiki.WikiContext;

/**
 * Plugin that displays latex math syntax as gif images.
 * Parameters may also be read from JspWiki-Properties. In this case the parameter names 
 * with prefix "math." are used as property names.
 *
 * @author Sebastian Baltes
 */
public class Math extends ACachedPlugin {

  public static final String PARAM_EQUATION = "latex";

  public static final String PARAM_ALIGN = "align";

  public static final String PARAM_MAX_HEIGHT = "maxheight";

  public static final String PARAM_MAX_WIDTH = "maxwidth";

  public static final String PARAM_FONT_SIZE = "fontsize";

  public static final String PARAM_COLOR = "color";

  public static final String PARAM_BGCOLOR = "bgcolor";

  protected void fillCache(WikiContext context, Map params, CacheHolder cacheHolder) throws Exception {
    // parse Parameters 
    PluginParameterParser parser = new PluginParameterParser(params, "Math plugin");      
    parser.setDefaultParams(context.getEngine().getWikiProperties(),"math.");
    String equation;
    try {
      equation = parser.getString(PARAM_EQUATION);
    } catch (ParameterNotFoundException e) {
      equation = parser.getString(PluginManager.PARAM_BODY, null);
      if (equation==null) {
        throw e;
      }
    }
    Integer fontSize = parser.getInteger(PARAM_FONT_SIZE, null);
    Color color = parser.getColor(PARAM_COLOR, null);
    Color bgcolor = parser.getColor(PARAM_BGCOLOR, null);
    Integer maxWidth = parser.getInteger(PARAM_MAX_WIDTH, null);
    Integer maxHeight = parser.getInteger(PARAM_MAX_HEIGHT, null);
    String align = parser.getString(PARAM_ALIGN, null);

    // create math gif
    MathHotEnqGifWriter mathWriter = new MathHotEnqGifWriter(equation);
    if (fontSize != null) {
      mathWriter.setFontSize(fontSize);
    }
    if (color != null) {
      mathWriter.setForegroundColor(color);
    }
    if (bgcolor != null) {
      mathWriter.setBackgroundColor(bgcolor);
    }
    if (maxWidth != null) {
      mathWriter.setMaxWidth(maxWidth.intValue());
    }
    if (maxHeight != null) {
      mathWriter.setMaxHeight(maxHeight.intValue());
    }

    ByteArrayOutputStream bout = new ByteArrayOutputStream();
    mathWriter.write(bout);
    DownloadHolder download = new DownloadHolder("math.gif", "image/gif", bout.toByteArray());

    String downloadUrl = cacheHolder.getCachedDownloadUrl(context, download);

    // write html
    StringBuffer result = new StringBuffer();
    result.append("<table border=\"0\"");
    if (align != null) {
      result.append(" align=\"" + align + "\"");
    }
    result.append(">\n");
    result.append("<tr><td>");
    result.append("<img src=\"" + downloadUrl + "\" class=\"math\"");
    result.append(" alt=\"" + equation + "\"");
    result.append(" />");
    result.append("</td></tr>\n");
    result.append("</table>\n");
    
    cacheHolder.setResult(result.toString());
  }

}