/*
 * Created on 24.07.2004
 * Copyright (C) 2004 Sebastian Baltes (sebastian.baltes@gmx.de)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 */
package com.ecyrd.jspwiki.plugin;

import java.io.IOException;
import java.io.PrintStream;
import java.util.NoSuchElementException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpUtils;

import org.apache.log4j.Category;

import com.ecyrd.jspwiki.WikiContext;
import com.ecyrd.jspwiki.WikiEngine;
import com.ecyrd.jspwiki.WikiPage;
import com.ecyrd.jspwiki.WikiProvider;
import com.ecyrd.jspwiki.providers.ProviderException;
import com.ecyrd.jspwiki.providers.WikiPageProvider;

/**
 * @author Sebastian Baltes
 */
public class ImageMapServlet extends HttpServlet {

  private static final Category log = Category.getInstance(DownloadJobServlet.class);
  private WikiEngine wikiEngine;

  public void init(ServletConfig arg0) throws ServletException {
    super.init(arg0);
    log.info("ImageMapServlet init");
    wikiEngine = WikiEngine.getInstance(getServletConfig());    
  }

  public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
    doAll(request,response);    
  }

  public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
    doAll(request,response);    
  }

  public void doAll(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
    Params params = new Params(request);
    response.setContentType("text/html");
    PrintStream out = new PrintStream(response.getOutputStream());
    switch (params.step) {
      case 1: 
        action1(params,out,request);
        break;
      case 2:
        action2(params,out,request);
        break;
      case 3:
        action3(params,out,request);
        break;      
    }
    out.close();
  }

  private void action1(Params params, PrintStream out, HttpServletRequest request) throws IOException, ServletException {  
    out.println("<HTML>");
    out.println("<BODY>");
    out.println("<H1>Image Map Editor</H1>");
    out.println("<b>1. Step: Click on a point in the image</b><br/>");
    out.println("<FORM ACTION=\""+HttpUtils.getRequestURL(request)+"\">");
    params.printParamsHiddenFields(out);
    out.println("  <INPUT TYPE=\"IMAGE\" NAME=\""+params.imageName+"\" SRC=\""+params.imageLink+"\"/>");
    out.println("</FORM>");
    out.println("</BODY>"); 
    out.println("</HTML>");
    out.close();
  }

  private void action2(Params params, PrintStream out, HttpServletRequest request) throws IOException, ServletException {  
    out.println("<HTML>");
    out.println("<BODY>");
    out.println("<H1>Image Map Editor</H1>");
    out.println("<b>2. Step: Choose a page name or link for the point</b><br/>");
    out.println("<i>Example: CityDortmund or [Dortmund|CityDortmund]</i>");
    out.println("<FORM ACTION=\""+HttpUtils.getRequestURL(request)+"\">");
    params.printParamsHiddenFields(out);
    out.println("  page name or link: <INPUT TYPE=\"INPUT\" NAME=\"link\"/>"); 
    out.println("  <INPUT TYPE=\"SUBMIT\" value=\"OK\"/>");
    out.println("</FORM>");
    out.println("</BODY>");
    out.println("</HTML>");
    out.close();
  }

  private void action3(Params params, PrintStream out, HttpServletRequest request) throws IOException, ServletException {
    // store new coords in page plugin text
    WikiPageProvider pageProvider = wikiEngine.getPageManager().getProvider();
    try {
      String pageText = pageProvider.getPageText(params.pageName, WikiProvider.LATEST_VERSION );
      StringBuffer pageTextBuffer = new StringBuffer(pageText);
      String coordtext = params.link+";"+params.x+";"+params.y+";20"+"\n";
      try {
        PluginScanner.appendTextToPlugin(pageTextBuffer, "ImageMap", "image=[\']?"+params.imageName+"[\']?", coordtext);
        WikiPage pageInfo = pageProvider.getPageInfo(params.pageName, WikiProvider.LATEST_VERSION );
        pageProvider.putPageText(pageInfo, pageTextBuffer.toString());
      } catch (NoSuchElementException e) {
        throw new ServletException("can not find ImageMapPlugin with image "+params.imageName+" in page "+params.pageName);                
      }
    } catch (ProviderException e) {
      throw new ServletException(e);
    }     
    out.println("<HTML>");
    out.println("<BODY>");
    out.println("<H1>Image Map Editor</H1>");
    out.println("<b>Your new link is created!</b><br/>");
    out.println(params.link+" ("+params.x+","+params.y+")<br/>");
    out.println("<b><A HREF=\""+wikiEngine.getViewURL(params.pageName)+"\">[Back to "+params.pageName+"]</a></b>");
    out.println("</BODY>");
    out.println("</HTML>");
    out.close();
  }

  public static String getEditUrl(WikiContext context, String pageName, String imageName, String imageLink) {
    return context.getEngine().getBaseURL() + "ImageMapServlet?pagename=" + pageName + "&imageName=" + imageName + "&imageLink=" + imageLink + "&step=1";
    
  }  
  
}

class Params {
  public String pageName;
  public String imageName;
  public String imageLink;
  public String x;
  public String y;
  public String link;  
  public int step;

  public Params(HttpServletRequest request) {
    pageName = request.getParameter("pagename");
    imageName = request.getParameter("imageName");
    imageLink = request.getParameter("imageLink");
    x = request.getParameter(imageName+".x");
    y = request.getParameter(imageName+".y");
    link = request.getParameter("link");
    String stepString = request.getParameter("step");      
    step = (stepString==null)?1:Integer.parseInt(stepString);
  }

  public void printParamsHiddenFields(PrintStream out) {
    printHiddenFieldIfValueNotNull(out,"pagename",pageName);
    printHiddenFieldIfValueNotNull(out,"imageName",imageName);
    printHiddenFieldIfValueNotNull(out,"imageLink",imageLink);
    printHiddenFieldIfValueNotNull(out,imageName+".x",x);
    printHiddenFieldIfValueNotNull(out,imageName+".y",y);
    printHiddenFieldIfValueNotNull(out,"link",link);
    printHiddenFieldIfValueNotNull(out,"step",""+(step+1));
  }

  private void printHiddenFieldIfValueNotNull(PrintStream out, String key, String value) {
    if (value!=null) {
      out.println("  <INPUT TYPE=\"HIDDEN\" NAME=\""+key+"\" value=\""+value+"\"/>");
    }
  }  
}