/*
 * Created on 24.07.2004
 * Copyright (C) 2004 Sebastian Baltes (sebastian.baltes@gmx.de)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 */
package com.ecyrd.jspwiki.plugin;

import java.io.StringReader;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import javax.swing.text.EditorKit;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;

import org.apache.log4j.Category;

import com.ecyrd.jspwiki.FileUtil;
import com.ecyrd.jspwiki.NoSuchVariableException;
import com.ecyrd.jspwiki.TextUtil;
import com.ecyrd.jspwiki.TranslatorReader;
import com.ecyrd.jspwiki.VariableManager;
import com.ecyrd.jspwiki.WikiContext;
import com.ecyrd.jspwiki.attachment.Attachment;

/**
 * 
 * @author Sebastian Baltes
 */
public class ImageMap implements WikiPlugin {

  private static final Category log = Category.getInstance(Applet.class);

  public static final String PARAM_IMAGE = "image";

  public static final String PARAM_ALIGN = "align";

  public static final String PARAM_HEIGHT = "height";

  public static final String PARAM_WIDTH = "width";
  
  /*
   * @see com.ecyrd.jspwiki.plugin.WikiPlugin#execute(com.ecyrd.jspwiki.WikiContext,
   *      java.util.Map)
   */
  public final String execute(WikiContext context, Map params) throws PluginException {
    try {
      return executeSafe(context, params);
    } catch (PluginException e) {
      throw e;
    } catch (Exception e) {
      String message = "error in " + this.getClass().getName() + ": " + e.getMessage();
      log.info(message, e);
      throw new PluginException(message);
    }
  }

  /**
   * @param context
   * @param params
   * @return
   */
  protected String executeSafe(WikiContext context, Map params) throws Exception {
    // parsing
    PluginParameterParser parser = new PluginParameterParser(params, "Applet plugin");
    String imageName = parser.getString(PARAM_IMAGE);
    String body = parser.getString(PluginManager.PARAM_BODY, "");
    Integer width = parser.getInteger(PARAM_WIDTH, null);
    Integer height = parser.getInteger(PARAM_HEIGHT, null);
    String align = parser.getString(PARAM_ALIGN, null);

//  <map name="Landkarte">
//  <area shape="circle" coords="x,y,r" href="http://www.wiesbaden.de/" alt="Wiesbaden" />
//  </map>
//  <img src="karte.gif" width="345" height="312" border="0" alt="Karte" usemap="#Landkarte">

    // write html
    StringBuffer result = new StringBuffer();
    result.append("<map name=\"" + imageName + "\">");    
    StringTokenizer tlines = new StringTokenizer(body,"\n\r");
    while (tlines.hasMoreTokens()) {
      String coords = "";
      String url = "";
      String alt = "";
      String shape = "circle";
      String line = tlines.nextToken();
      StringTokenizer tcomma = new StringTokenizer(line,";");
      if (tcomma.hasMoreTokens()) {
        String wlink = tcomma.nextToken();
        if (wlink.indexOf("[")==-1) {
          wlink = "["+wlink+"]";
        }
        TranslatorReader in = new TranslatorReader( context, new StringReader( wlink ) );
        // <a href="url" alt="alt">alt</a>
        String a = FileUtil.readContents( in );
        int lhref = a.indexOf("href=\"");
        if (lhref==-1) {
          lhref = a.indexOf("HREF=\"");
        }
        if (lhref==-1) {
          continue;
        }
        lhref += 6;
        int rhref = a.indexOf("\"",lhref);
        if (rhref<lhref) {
          continue;
        }
        url = a.substring(lhref,rhref);
        int lalt = a.indexOf("alt=\"");
        if (lalt==-1) {
          lalt = a.indexOf("ALT=\"");
        }
        if (lalt>0) {
          lalt += 5; 
          int ralt = a.indexOf("\"",lalt);
          if (ralt>lalt) {
            alt = a.substring(lalt,ralt);
          }
        } else {
          int ltext = a.indexOf(">");
          int rtext = a.indexOf("<",ltext);
          if (ltext>rtext) {
            alt = a.substring(ltext+1,rtext);                      
          }
        }
      }
      while (tcomma.hasMoreTokens()) {
        String token = tcomma.nextToken();
        try {
          Integer.parseInt(token);
          coords=coords+token+(tcomma.hasMoreTokens()?",":"");          
        } catch (NumberFormatException e) {
          shape = token;
        }
      }
      result.append("<area shape=\""+shape+"\" coords=\""+coords+"\" href=\""+url+"\" alt=\""+alt+"\"/>");
    }    
    result.append("</map>");

    String link = imageName;  
    Attachment attachment = context.getEngine().getAttachmentManager().getAttachmentInfo(context, imageName);
    if (attachment != null) {
      link = context.getEngine().getAttachmentURL(attachment.getName());
    }
    result.append("<img class=\"ImageMap\" src=\""+ link +"\" usemap=\"#"+ imageName +"\"");

    if (align != null) {
      result.append(" align=\"" + align + "\"");
    }
    if (width != null) {
      result.append(" width=\"" + width + "\"");
    }
    if (height != null) {
      result.append(" height=\"" + height + "\"");
    }
    result.append(">\n");
    String editUrl = ImageMapServlet.getEditUrl(context, context.getPage().getName(), imageName, link);
    result.append("<a class=\"ImageMap\" href=\""+ editUrl +"\">[edit]</a>");
    return result.toString();
  }
    
}