/*
 * Created on 24.07.2004
 * Copyright (C) 2004 Sebastian Baltes (sebastian.baltes@gmx.de)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 */
package com.ecyrd.jspwiki.plugin;

import java.io.IOException;
import java.io.OutputStream;

import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.log4j.Category;

import com.ecyrd.jspwiki.WikiContext;

/**
 * @author Sebastian Baltes
 */
public class DownloadJobServlet extends HttpServlet {

  private static final Category log = Category.getInstance(ImageMapServlet.class);

  public void init(ServletConfig arg0) throws ServletException {
    super.init(arg0);
    log.info("DownloadJobServlet init");
  }

  public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
    String id = request.getParameter("id");
    DownloadHolder downloadHolder;
    if (id==null) {
      String pluginId = request.getParameter("pluginId");
      String downloadId = request.getParameter("downloadId");
      log.debug("DownloadJobServlet get pluginId " + id + " downloadId " + downloadId);
      CachePluginManager cachePluginManager = CachePluginManager.getInstance();
      CacheHolder cacheHolder = cachePluginManager.getCacheHolder(pluginId);
      downloadHolder = (DownloadHolder) cacheHolder.getDownloads().get(downloadId);      
    } else {
      log.debug("DownloadJobServlet get id " + id);
      HttpSession session = request.getSession(true);
      downloadHolder = (DownloadHolder) session.getAttribute(id);
      session.removeAttribute(id);
    }

    if (downloadHolder != null) {
      if (downloadHolder.getName() != null) {
        String quot = "\"";
        response.addHeader("Content-Disposition", "attachment; filename=" + quot + downloadHolder.getName() + quot);
      }
      if (downloadHolder.getMimeType() != null) {
        response.setContentType(downloadHolder.getMimeType());
      }
      OutputStream out = response.getOutputStream();
      out.write(downloadHolder.getBytes());
      out.flush();
      out.close();
    }
  }

  /**
   * @param request
   * @param id
   * @param download
   */
  public static String getDownloadUrl(WikiContext context, DownloadHolder download) {
    if (context != null && context.getHttpRequest()!=null) {
      String id = String.valueOf((long) (java.lang.Math.random() * Long.MAX_VALUE));
      context.getHttpRequest().getSession(true).setAttribute(id, download);
      return context.getEngine().getBaseURL() + "downloadJob?id=" + id;
    } else {
      return null;
    }

  }

  /**
   * @param id
   * @param downloadId
   * @return
   */
  public static String getCachePluginManagerDownloadUrl(WikiContext context, String id, String downloadId) {
    return context.getEngine().getBaseURL() + "downloadJob?pluginId=" + id + "&downloadId=" + downloadId;
  }

}

