/*
 * Created on 24.07.2004
 * Copyright (C) 2004 Sebastian Baltes (sebastian.baltes@gmx.de)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 */
package com.ecyrd.jspwiki.plugin;

import java.io.Serializable;

/**
 * @author Sebastian Baltes
 */
public class DownloadHolder implements Serializable {

  private String name;

  private String mimeType;

  private byte[] bytes;

  public DownloadHolder() {
  }

  /**
   * @param name
   * @param mimeType
   * @param bytes
   */
  public DownloadHolder(String name, String mimeType, byte[] bytes) {
    super();
    this.name = name;
    this.mimeType = mimeType;
    this.bytes = bytes;
  }

  /**
   * @return Returns the bytes.
   */
  public byte[] getBytes() {
    return bytes;
  }

  /**
   * @param bytes
   *          The bytes to set.
   */
  public void setBytes(byte[] bytes) {
    this.bytes = bytes;
  }

  /**
   * @return Returns the mimeType.
   */
  public String getMimeType() {
    return mimeType;
  }

  /**
   * @param mimeType
   *          The mimeType to set.
   */
  public void setMimeType(String mimeType) {
    this.mimeType = mimeType;
  }

  /**
   * @return Returns the name.
   */
  public String getName() {
    return name;
  }

  /**
   * @param name
   *          The name to set.
   */
  public void setName(String name) {
    this.name = name;
  }
}