/*
 * Created on 11.08.2004
 * Copyright (C) 2004 Sebastian Baltes (sebastian.baltes@gmx.de)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 */
package com.ecyrd.jspwiki.plugin;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

/**
 * @author Sebastian Baltes
 */
public class CachePluginManager {

  // TODO JUnit - Tests!
  
  // TODO make this configurable
  public final static int MAX_ENTRIES = 1024; 

  private static final CachePluginManager instance = new CachePluginManager();
  
  private CachePluginManager() {    
  }

  // TODO A SoftReference based Map would be the best, but for now (11.08.2004) we can not use it
  // because of a bug, see http://www.theserverside.com/discussions/thread.tss?thread_id=26023
  private Map cacheId2CacheHolder = new LinkedHashMap(MAX_ENTRIES + 1, .75F, true) {
    public boolean removeEldestEntry(Map.Entry eldest) {
      boolean removeit = size() > MAX_ENTRIES;
      CacheHolder cacheHolder = (CacheHolder) eldest.getValue(); 
      cacheName2Id.remove(cacheHolder.getName());
      return removeit;
    }
  };
  private Map cacheName2Id = new HashMap();

  public static final CachePluginManager getInstance() {
    return instance;
  }

  /**
   * @param name
   * @param context
   * @param params
   * @return
   */
  public synchronized CacheHolder getCacheHolder(String pluginClassName, Map params) {
    String name = toName(pluginClassName, params);
    String id = getId(name);
    if (id==null) {
      return null;
    } else {
      return getCacheHolder(id);
    } 
  }

  /**
   * @param pluginId
   * @return
   */
  public synchronized CacheHolder getCacheHolder(String id) {
    return (CacheHolder) cacheId2CacheHolder.get(id);
  }
  
  /**
   * @param cacheHolder
   */
  public synchronized void storeCacheHolder(CacheHolder cacheHolder) {
    cacheName2Id.put(cacheHolder.getName(), cacheHolder.getId());
    cacheId2CacheHolder.put(cacheHolder.getId(), cacheHolder);
  }

  /**
   * @param name
   * @param context
   * @param params
   * @return
   */
  public synchronized CacheHolder createCacheHolder(String pluginClassName, Map params) {
    String name = toName(pluginClassName, params);
    String id = createUniqueId(); 
    return new CacheHolder(id,name);
  }
  

  private String toName(String pluginClassName, Map params) {
    SortedMap sortedMap = new TreeMap(params);
    String name = pluginClassName+sortedMap;
    return name;
  }

  private String getId(String name) {
    return (String) cacheName2Id.get(name);
  }

  private static String createUniqueId() {
    return String.valueOf((long) (java.lang.Math.random() * Long.MAX_VALUE));    
  }

}