/*
 * Created on 11.08.2004
 * Copyright (C) 2004 Sebastian Baltes (sebastian.baltes@gmx.de)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 */
package com.ecyrd.jspwiki.plugin;

import java.util.HashMap;
import java.util.Map;

import com.ecyrd.jspwiki.WikiContext;

/**
 * @author Sebastian Baltes
 */
public class CacheHolder {

  private String id;
  private String name;
  private String result;
  private Map downloads = new HashMap();

  /**
   * @param id
   * @param name
   */
  public CacheHolder(String id, String name) {
    this.id = id;
    this.name = name;
  }

  /**
   * Stores a download to the cache and returns the url of the download
   * 
   * @param context
   * @param downloadHolder
   * @return url of the download
   */
  protected String getCachedDownloadUrl(WikiContext context, DownloadHolder downloadHolder) {
    String downloadId = String.valueOf(downloads.size());
    downloads.put(downloadId,downloadHolder);
    return DownloadJobServlet.getCachePluginManagerDownloadUrl(context,id,downloadId);
  }

  /**
   * @return Returns the id.
   */
  public String getId() {
    return id;
  }
    
  /**
   * @return Returns the result.
   */
  public String getResult() {
    return result;
  }
  
  /**
   * @param result The result to set.
   */
  public void setResult(String result) {
    this.result = result;
  }
  
  /**
   * @return Returns the downloads.
   */
  public Map getDownloads() {
    return downloads;
  }
  /**
   * @return Returns the name.
   */
  public String getName() {
    return name;
  }
}
