/*
 * Created on 24.07.2004
 * Copyright (C) 2004 Sebastian Baltes (sebastian.baltes@gmx.de)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 */
package com.ecyrd.jspwiki.plugin;

import java.util.Map;

import org.apache.log4j.Category;

import com.ecyrd.jspwiki.WikiContext;

/**
 * 
 * @author Sebastian Baltes
 */
public abstract class ACachedPlugin implements WikiPlugin {

  private static final Category log = Category.getInstance(ImageMap.class);

  /*
   * @see com.ecyrd.jspwiki.plugin.WikiPlugin#execute(com.ecyrd.jspwiki.WikiContext,
   *      java.util.Map)
   */
  public final String execute(WikiContext context, Map params) throws PluginException {
    try {
      CachePluginManager cachePluginManager = CachePluginManager.getInstance();
      CacheHolder cacheHolder = cachePluginManager.getCacheHolder(this.getClass().getName(), params);
      if (cacheHolder == null) {
        cacheHolder = cachePluginManager.createCacheHolder(this.getClass().getName(), params);
        fillCache(context, params, cacheHolder);
        cachePluginManager.storeCacheHolder(cacheHolder);
      }
      return cacheHolder.getResult();
    } catch (PluginException e) {
      throw e;
    } catch (Exception e) {
      String message = "error in " + this.getClass().getName() + ": " + e.getMessage();
      log.info(message, e);
      throw new PluginException(message);
    }
  }

  protected abstract void fillCache(WikiContext context, Map params, CacheHolder cacheHolder) throws Exception;

}